<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "addLeerling opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['gebruikersnaam']) && strlen($_GET['gebruikersnaam']) > 1){
		show_error_and_log($logfolder, "addLeerling opgevraagd zonder gebruikersnaam van de nieuwe leerling");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "addLeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "addLeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}
	
	
	$gebruikersnaam = $_GET['gebruikersnaam'];
	$session_hash   = $_GET['session_hash']; 
	$lerarenid	    = $_GET['lerarenid'];
	
	$verify_url = $toolbox_url.'/public/validate_ad_addleerling.php?session_hash='.$session_hash.'&key='.$ad_key.'&gebruikersnaam='.$gebruikersnaam;

	$return = file_get_contents($verify_url);
	
	
	if(substr($return, 0, 4) == 'Fout'){
		show_error_and_log($logfolder, $return);
		exit;
	}
	
	$return = json_decode($return);

	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object) voor addLeerling");
		exit;
	}	

	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor addLeerling");
		exit;
	}	
	
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor addLeerling");
		exit;
	}
							
	$name 				= str_replace('"', '', $return->voornaam.' '.$return->naam);
	$givenname 			= str_replace('"', '', $return->voornaam);
	$surname 			= str_replace('"', '', $return->naam);
	$samaccountname 	= substr($return->gebruikersnaam,0, 20);
	$userprincipalname  = $return->adgebruikersnaam;
	$email  			= $return->email;
	$displayname		= $return->displayname;
	$title				= $return->title;
	
	$path 				= $return->ou;
	$accountpassword	= $return->paswoord;
	
	$passwordneverexpires  = $return->pwd_never_expires;
	$changepasswordatlogin = $return->pwd_wijzigen_login;
	$cannotchangepassword  = $return->pwd_niet_wijzigen;
	
	$scriptpath			   = empty($return->logon_script)?"empty":$return->logon_script;
	$description		   = empty($return->omschrijving)?"empty":$return->omschrijving;
	$homedrive			   = empty($return->driveletter)?"empty":$return->driveletter;
	$homedirectory		   = empty($return->homefolder)?"empty":$return->homefolder;
	
	$pointer			   = empty($return->pointer)?"empty":$return->pointer;	
	
	$groepen 			   = $return->groepen;
	
	$strGroepen = 'empty';
	$blnFirst 	= true;
	
	if(!is_array($groepen)){
		$groepen = explode(',', $groepen);
	}
	
	if(is_array($groepen)){
		foreach($groepen as $groep){
			if(trim($groep != '')){
				if($blnFirst){
					$strGroepen = trim($groep);
					$blnFirst = false;
				}
				else{
					$strGroepen .= ','.trim($groep);
				}
			}
		}
	}


	$arr_data = array();
	log_to_file($logfolder, "powershell -file C:\\toolbox\\powershell\\addLeerling.ps1 -name \"$displayname\" -givenname \"$givenname\" -surname \"$surname\" -samaccountname \"$samaccountname\" -userprincipalname \"$userprincipalname\" -email \"$email\" -displayname \"$displayname\" -title \"$title\" -path \"$path\" -passwordneverexpires \"$passwordneverexpires\" -changepasswordatlogin \"$changepasswordatlogin\" -cannotchangepassword \"$cannotchangepassword\" -description \"$description\" -scriptpath \"$scriptpath\" -homedrive \"$homedrive\" -homedirectory \"$homedirectory\" -employeenumber \"$pointer\" -groepen \"$strGroepen\"");
	exec("powershell -file C:\\toolbox\\powershell\\addLeerling.ps1 -name \"$displayname\" -givenname \"$givenname\" -surname \"$surname\" -samaccountname \"$samaccountname\" -userprincipalname \"$userprincipalname\" -email \"$email\" -displayname \"$displayname\" -title \"$title\" -path \"$path\" -accountpassword \"$accountpassword\" -passwordneverexpires \"$passwordneverexpires\" -changepasswordatlogin \"$changepasswordatlogin\" -cannotchangepassword \"$cannotchangepassword\" -description \"$description\" -scriptpath \"$scriptpath\" -homedrive \"$homedrive\" -homedirectory \"$homedirectory\" -employeenumber \"$pointer\" -groepen \"$strGroepen\"",$arr_data);
	
	log_to_file($logfolder, var_export($arr_data, true));
	
	if(count($arr_data) == 0){
		log_to_file($logfolder, "Leerlingaccount $samaccountname aangemaakt door lerarenid $lerarenid vanuit ip $ip");
		echo "1";
	}
	else{
		log_to_file($logfolder, "Leerlingaccount $samaccountname niet aangemaakt door lerarenid $lerarenid vanuit ip $ip: ".serialize(json_encode($arr_data)));
		echo json_encode($arr_data);
	}

?>